"use client";

import { cn } from "@/lib/utils";
import Image from "next/image";
import { useState } from "react";

import type { ComponentProps } from "react";

export default function ImageBlur(props: ComponentProps<typeof Image>) {
  const [isLoading, setLoading] = useState(true);

  return (
    <Image
      {...props}
      alt={props.alt}
      className={cn(
        props.className,
        "duration-700 ease-in-out",
        isLoading ? "scale-105 blur-lg" : "scale-100 blur-0",
      )}
      onLoad={() => setLoading(false)}
    />
  );
}